<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */
namespace Application\Core\Notification;

/**
 * NotificationConfigInterface
 */
interface NotificationConfigInterface
{
    public function getSenderToAdmin(): string;

    public function getRecipientToAdmin(): string;

    public function getReplyToAdmin(): string;

    public function getSenderToUser(): string;

    public function getRecipientToUser(): string;

    public function getReplyToUser(): string;

    public function getSubjectToAdmin(): string;

    public function getContentToAdmin(): string;

    public function getSubjectToUser(string $language_iso): string;

    public function getContentToUser(string $language_iso): string;
}
