<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use ArrayIterator;

class NotificationCollection implements \IteratorAggregate
{
    /**
     * @var NotificationInterface[]
     */
    protected $collection = [];

    /**
     * @return NotificationInterface[]
     */
    public function getIterator(): \Traversable
    {
        return new ArrayIterator($this->collection);
    }

    public function add(NotificationInterface $notification): self
    {
        $this->collection[$notification->getName()] = $notification;

        return $this;
    }

    public function get(string $name): NotificationInterface
    {
        if (!isset($this->collection[$name])) {
            throw new \InvalidArgumentException('The notification "' . $name . '" does not exist');
        }

        return $this->collection[$name];
    }

    public function has(string $name): bool
    {
        return isset($this->collection[$name]);
    }

    public function del(string $name): self
    {
        unset($this->collection[$name]);

        return $this;
    }
}
