<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * HasSettingsLinkTrait
 */
trait HasSettingsLinkTrait
{
    /**
     * @var string
     */
    protected $settings_link;

    public function getSettingsLink(): string
    {
        if ($this->settings_link === null) {
            throw new \BadMethodCallException('You first need to set the settings link!');
        }

        return $this->settings_link;
    }

    public function setSettingsLink(string $settings_link): self
    {
        $this->settings_link = $settings_link;

        return $this;
    }
}
