<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * HasResetPasswordLinkTrait
 */
trait HasResetPasswordLinkTrait
{
    /**
     * @var string
     */
    protected $reset_password_link;

    public function getResetPasswordLink(): string
    {
        if ($this->reset_password_link === null) {
            throw new \BadMethodCallException('You first need to set the reset password link!');
        }

        return $this->reset_password_link;
    }

    public function setResetPasswordLink(string $reset_link): self
    {
        $this->reset_password_link = $reset_link;

        return $this;
    }
}
