<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use BadMethodCallException;

/**
 * HasPasswordTrait
 */
trait HasPasswordTrait
{
    /**
     * @var string
     */
    protected $password;

    public function getPassword(): string
    {
        if ($this->password === null) {
            throw new BadMethodCallException('You first need to set the password!');
        }

        return $this->password;
    }

    public function setPassword(string $password): self
    {
        $this->password = $password;
        
        return $this;
    }
}
