<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\AccountInterface;

/**
 * HasAccountTrait
 */
trait HasAccountTrait
{
    /**
     * @var AccountInterface
     */
    protected $account;

    public function getAccount(): AccountInterface
    {
        if ($this->account === null) {
            throw new \BadMethodCallException('You first need to set the account!');
        }

        return $this->account;
    }

    public function setAccount(AccountInterface $account): self
    {
        $this->account = $account;

        return $this;
    }
}
