<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * HasAccountActivationLinkTrait
 */
trait HasAccountActivationLinkTrait
{
    /**
     * @var string
     */
    protected $account_activation_link;

    public function getAccountActivationLink(): string
    {
        if ($this->account_activation_link === null) {
            throw new \BadMethodCallException('You first need to set the account activation link!');
        }

        return $this->account_activation_link;
    }

    public function setAccountActivationLink(string $activation_link): self
    {
        $this->account_activation_link = $activation_link;
        
        return $this;
    }
}
