<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\LanguageInterface;

class ForgotPasswordNotification extends AbstractNotification
{
    use HasAccountTrait;
    use HasResetPasswordLinkTrait;
    /**
     * {@inheritdoc}
     */
    public function getName(): string
    {
        return 'core.user_forgot_password';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle(): string
    {
        return $this->translator->trans('User forgot password');
    }

    /**
     * {@inheritdoc}
     */
    public function getOptions(): NotificationOptions
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions([
                'send_to_admin' => false,
                'send_to_user'  => true,
            ]);
        }

        return $this->options;
    }

    /**
     * {@inheritdoc}
     */
    public function getLanguage(): LanguageInterface
    {
        return $this->getAccount()->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars(): array
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_ROLE';
        $vars[] = 'RESET_PASSWORD_LINK';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars(): array
    {
        $vars = parent::getEmailVars();

        $vars['USER_USERNAME'] = $this->getAccount()->getUsername();
        $vars['USER_EMAIL'] = $this->getAccount()->getEmail();
        $vars['USER_FULL_NAME'] = $this->getAccount()->getUserDetails()->name();
        $vars['USER_ROLE'] = $this->getAccount()->getRole()->getName();
        $vars['RESET_PASSWORD_LINK'] = $this->getResetPasswordLink();

        return $vars;
    }
}
