<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification\Exception;

use Throwable;

class SendException extends \Exception
{
    /**
     * @var string
     */
    protected $send_type;

    public function __construct(string $message, string $send_type, ?Throwable $prev_exception = null)
    {
        parent::__construct($message, 0, $prev_exception);

        $this->send_type = $send_type;
    }

    public function getSendType(): string
    {
        return $this->send_type;
    }
}
