<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Model\Setting;

class SettingManager
{
    /**
     * @var Setting[]
     */
    protected $settings = [];

    /**
     * @param $key
     * @return Setting
     */
    public function get($key)
    {
        if (!array_key_exists($key, $this->settings)) {
            $setting = Setting::find(['conditions' => ['`key` = ?', $key]]);

            if ($setting !== null) {
                $this->settings[$key] = $setting;
            } else {
                return null;
            }
        }

        return $this->settings[$key];
    }

    /**
     * @param $key
     * @return string
     */
    public function value($key)
    {
        if (($setting = $this->get($key)) !== null) {
            return $this->get($key)->value;
        }

        return null;
    }

    /**
     * @param $key
     * @return bool
     */
    public function delete($key)
    {
        $setting = $this->get($key);

        if ($setting && !$setting->delete()) {
            return false;
        }

        unset($this->settings[$key]);

        return true;
    }
}
