<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Model\Role;

class RoleManager implements RoleManagerInterface
{
    protected $models;

    /**
     * {@inheritdoc}
     *
     * @param int $id
     * @return Role
     */
    public function findById($id)
    {
        $this->prepare();

        if (array_key_exists($id, $this->models)) {
            return $this->models[$id];
        }

        return null;
    }

    /**
     * {@inheritdoc}
     *
     * @return Role[]
     */
    public function findAll()
    {
        $this->prepare();

        return $this->models;
    }

    /**
     * Precarica i ruoli
     */
    protected function prepare()
    {
        if ($this->models === null) {
            $this->models = [];
            $options = ['order' => 'position ASC, id ASC'];

            /** @var Role $role */
            foreach (Role::all($options) as $role) {
                $this->models[$role->getId()] = $role;
            }
        }
    }
}
