<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\RegionInterface;
use Application\Core\Model\Province;

class ProvinceManager implements ProvinceManagerInterface
{
    /**
     * @var Province[]
     */
    protected $models;

    /**
     * @param int $id
     * @return Province
     */
    public function findById($id)
    {
        $this->prepare();

        if (array_key_exists($id, $this->models)) {
            return $this->models[$id];
        }

        return null;
    }

    /**
     * @param string $plate
     * @return Province
     */
    public function findByPlate($plate)
    {
        $models = array_filter(
            $this->findAll(),
            function (Province $model) use ($plate) {
                return $model->getPlate() === $plate;
            }
        );

        if ($models !== []) {
            return reset($models);
        }

        return null;
    }

    /**
     * @return Province[]
     */
    public function findAll()
    {
        $this->prepare();

        return $this->models;
    }

    /**
     * @param int|RegionInterface $region
     * @return Province[]
     */
    public function findByRegion($region)
    {
        $region_id = is_numeric($region) ? intval($region) : $region->getId();

        return array_filter(
            $this->findAll(),
            function (Province $model) use ($region_id) {
                return $model->getRegionId() === $region_id;
            }
        );
    }

    /**
     * Precarica le province
     */
    protected function prepare()
    {
        if ($this->models === null) {
            $this->models = [];

            /** @var Province $province */
            foreach (Province::all(['order' => 'name ASC']) as $province) {
                $this->models[$province->getId()] = $province;
            }
        }
    }
}
