<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\NotificationTemplateInterface;

/**
 * NotificationTemplateManagerInterface
 */
interface NotificationTemplateManagerInterface
{
    /**
     * @param int               $id
     * @param LanguageInterface $language
     * @return NotificationTemplateInterface
     */
    public function findById($id, ?LanguageInterface $language = null);

    /**
     * @param string            $notificationName
     * @param LanguageInterface $language
     * @return NotificationTemplateInterface
     */
    public function findByNotification($notificationName, ?LanguageInterface $language = null);

    /**
     * @param string $orderBy
     * @param int    $limit
     * @param int    $offset
     * @return NotificationTemplateInterface[]
     */
    public function findAll(array $conditions = [], $orderBy = null, $limit = null, $offset = null);

    /**
     * Serve per l'eventuale paginazione in backend
     *
     * @return int
     */
    public function countAll(array $conditions = []);
}
