<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Entity\ModuleInterface;

/**
 * Interface ModuleManagerInterface
 */
interface ModuleManagerInterface
{
    /**
     * @return ModuleInterface[]
     */
    public function findAll();

    /**
     * @param int $site_id
     * @return ModuleInterface[]
     */
    public function findAllBySite($site_id);

    /***
     * @param string $controller
     * @return ModuleInterface[]
     */
    public function findAllByController($controller);

    /**
     * @param int $module_id
     * @return ModuleInterface
     */
    public function findById($module_id);

    /**
     * @param string $controller
     * @return ModuleInterface
     */
    public function create($controller);

    /**
     * @return $this
     */
    public function save(ModuleInterface $module);
}
