<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

use Application\Core\Model\Group;

class GroupManager implements GroupManagerInterface
{
    /**
     * @var Group[]
     */
    protected $groups;

    /**
     * {@inheritdoc}
     */
    public function findById($id)
    {
        $this->prepare();

        if (array_key_exists($id, $this->groups)) {
            return $this->groups[$id];
        }

        return null;
    }

    /**
     * {@inheritdoc}
     */
    public function findAll()
    {
        $this->prepare();

        return $this->groups;
    }

    private function prepare()
    {
        if ($this->groups === null) {
            $this->groups = [];
            $options = ['order' => 'position ASC, name ASC'];

            /** @var Group $group */
            foreach (Group::all($options) as $group) {
                $this->groups[$group->getId()] = $group;
            }
        }
    }
}
