<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

/**
 * @internal
 */
class CoreManagerRegistryCache
{
    protected $cache = [];

    /**
     * @param string $entity_name
     * @param int    $id
     * @return mixed
     */
    public function get($entity_name, $id)
    {
        if (!isset($this->cache[$entity_name][$id])) {
            return null;
        }

        return $this->cache[$entity_name][$id];
    }

    /**
     * @param string $entity_name
     * @return array
     */
    public function all($entity_name)
    {
        if (!isset($this->cache[$entity_name])) {
            return [];
        }

        return $this->cache[$entity_name];
    }

    /**
     * @param string $entity_name
     * @param int    $id
     * @param mixed  $entity
     */
    public function set($entity_name, $id, $entity)
    {
        $this->cache[$entity_name][$id] = $entity;
    }

    /**
     * @return $this
     */
    public function clear()
    {
        $this->cache = [];
    }

    /**
     * @return bool
     */
    public function isEmpty($entity_name = null)
    {
        if ($entity_name) {
            if (!isset($this->cache[$entity_name])) {
                return true;
            }

            return empty($this->cache[$entity_name]);
        }

        return empty($this->cache);
    }
}
