<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model\Manager;

class CoreManagerRegistry
{
    /**
     * @var SiteManager
     */
    protected $site_manager;

    /**
     * @var ModuleManager
     */
    protected $module_manager;

    /**
     * @var LanguageManager
     */
    protected $language_manager;

    /**
     * @var ModuleSiteManager
     */
    protected $module_site_manager;

    /**
     * @var LanguageSiteManager
     */
    protected $language_site_manager;

    /**
     * @var LanguageModuleManager
     */
    protected $language_module_manager;

    /**
     * @var CoreManagerRegistryCache
     */
    protected $cache;

    public function __construct(CoreManagerRegistryCache $cache)
    {
        $this->cache = $cache;
    }

    /**
     * @return SiteManager
     */
    public function getSiteManager()
    {
        if ($this->site_manager === null) {
            $this->site_manager = new SiteManager($this);
        }

        return $this->site_manager;
    }

    /**
     * @return LanguageManager
     */
    public function getLanguageManager()
    {
        if ($this->language_manager === null) {
            $this->language_manager = new LanguageManager($this);
        }

        return $this->language_manager;
    }

    /**
     * @return ModuleManager
     */
    public function getModuleManager()
    {
        if ($this->module_manager === null) {
            $this->module_manager = new ModuleManager($this);
        }

        return $this->module_manager;
    }

    /**
     * @return ModuleSiteManager
     */
    public function getModuleSiteManager()
    {
        if ($this->module_site_manager === null) {
            $this->module_site_manager = new ModuleSiteManager($this);
        }

        return $this->module_site_manager;
    }

    /**
     * @return LanguageSiteManager
     */
    public function getLanguageSiteManager()
    {
        if ($this->language_site_manager === null) {
            $this->language_site_manager = new LanguageSiteManager($this);
        }

        return $this->language_site_manager;
    }

    /**
     * @return LanguageModuleManager
     */
    public function getLanguageModuleManager()
    {
        if ($this->language_module_manager === null) {
            $this->language_module_manager = new LanguageModuleManager($this);
        }

        return $this->language_module_manager;
    }

    /**
     * @return CoreManagerRegistryCache
     */
    public function getCache()
    {
        return $this->cache;
    }
}
