<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

trait FromArrayTrait
{
    /**
     * Questo metodo serve a generare l’entity partendo dal risultato di una query in database.
     * È fortemente sconsigliato usare questo metodo per altri scopi.
     *
     * @link https://stackoverflow.com/a/64572363
     *
     * @internal
     */
    public static function createFromArray(array $data): self
    {
        $entity = new self();
        foreach (get_object_vars($entity) as $property => $default) {
            $entity->$property = $data[$property] ?? $default;
        }

        return $entity;
    }
}
