<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\CountryInterface;

/**
 * Modello per i paesi.
 *
 * @property int    $id
 * @property string $name
 * @property string $code
 * @property string $code3
 * @property string $num
 * @property string $phone_code
 * @property string $currency_name
 * @property string $currency_code
 * @property string $currency_number
 * @property int    $currency_decimals
 */
class Country extends Base implements CountryInterface
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'countries';

    /**
     * {@inheritdoc}
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->name;
    }

    public function __toString(): string
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * {@inheritdoc}
     */
    public function getCode3()
    {
        return $this->code3;
    }

    /**
     * {@inheritdoc}
     */
    public function getNum()
    {
        return $this->num;
    }

    /**
     * {@inheritdoc}
     */
    public function getPhoneCode()
    {
        return $this->phone_code;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrencyName()
    {
        return $this->currency_name;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrencyCode()
    {
        return $this->currency_code;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrencyNumber()
    {
        return $this->currency_number;
    }

    /**
     * {@inheritdoc}
     */
    public function getCurrencyDecimals()
    {
        return $this->currency_decimals;
    }
}
