<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;
use Application\Core\Entity\CityInterface;

/**
 * @property int    $id
 * @property int    $province_id
 * @property int    $region_id
 * @property string $name
 */
class City extends Base implements CityInterface, \Stringable
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'cities';

    /**
     * @param int $region_id
     * @return City[]
     */
    public static function allByRegion($region_id)
    {
        return static::all([
            'conditions' => ['region_id = :region', 'region' => $region_id],
            'order'      => 'name',
        ]);
    }

    /**
     * @param int $province_id
     * @return City[]
     */
    public static function allByProvince($province_id)
    {
        return static::all([
            'conditions' => ['province_id = :province', 'province' => $province_id],
            'order'      => 'name',
        ]);
    }

    public function __toString(): string
    {
        return $this->name;
    }
}
