<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

final class BannedEmailMatcher
{
    public const REGEX_MATCH = 'regex';

    public const STRICT_MATCH = 'strict';

    /**
     * @param string $email
     * @param string $matchType
     * @param string $matchCompare
     * @return bool
     */
    public function match($email, $matchType, $matchCompare)
    {
        if ($matchType === self::REGEX_MATCH) {
            $regex = '/' . preg_quote($matchCompare, '/') . '/';

            return (bool) preg_match($regex, $email);
        }

        if ($matchType === self::STRICT_MATCH) {
            return $matchCompare === $email;
        }

        return true;
    }
}
