<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * @property int    $id
 * @property string $match_type
 * @property string $match_compare
 */
final class BannedEmail extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'banned_emails';

    /**
     * @param string $email
     * @return bool
     */
    public function match($email)
    {
        return (new BannedEmailMatcher())->match($email, $this->match_type, $this->match_compare);
    }
}
