<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Model;

use ActiveRecord\Base;

/**
 * @property int         $app_id
 * @property int         $site_id
 * @property Application $application
 * @property Site        $site
 */
class ApplicationSite extends Base
{
    /**
     * Nome della tabella.
     *
     * @var string
     */
    public static $table_name = 'apps_sites';

    /**
     * Chiave primaria.
     *
     * @var array
     */
    public static $primary_key = ['app_id', 'site_id'];

    /**
     * Relazioni 'belongs_to'.
     *
     * @var array
     */
    public static $belongs_to = [
        ['application', 'model' => Application::class],
        ['site', 'model' => Site::class],
    ];
}
