<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType;

use Application\Core\Entity\LinkTypeInterface;

/**
 * ResourceInterface
 */
interface ResourceInterface
{
    /**
     * @return string
     */
    public function getTitle(LinkTypeInterface $link_type);

    /**
     * @return string
     */
    public function getPermalink(LinkTypeInterface $link_type);

    /**
     * @return mixed
     */
    public function getResource(LinkTypeInterface $link_type);

    public function updateCache(LinkTypeInterface $link_type);
}
