<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType\Resource;

use Application\Core\Entity\LinkTypeInterface;
use Application\Core\LinkType\ResourceInterface;

class LinkResource implements ResourceInterface
{
    /**
     * {@inheritdoc}
     */
    public function getTitle(LinkTypeInterface $link_type)
    {
        return $link_type->getUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getPermalink(LinkTypeInterface $link_type)
    {
        return absolute_url($link_type->getUrl());
    }

    /**
     * {@inheritdoc}
     */
    public function getResource(LinkTypeInterface $link_type)
    {
        return null;
    }

    /**
     * {@inheritdoc}
     */
    public function updateCache(LinkTypeInterface $link_type)
    {
    }
}
