<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType;

use Application\Core\Entity\LinkTypeDetails;
use Application\Core\Entity\LinkTypeInterface;

/**
 * LinkHandlerInterface
 */
interface LinkHandlerInterface
{
    /**
     * @return string
     */
    public function getName();

    /**
     * @return string
     */
    public function getLabel();

    /**
     * @return string
     */
    public function getUrl(array $request);

    /**
     * @return int|string
     */
    public function getValue(LinkTypeInterface $link_type);

    /**
     * @return LinkTypeDetails
     */
    public function getDetails(array $request);

    /**
     * @return string|null
     */
    public function getGroup();

    /**
     * @param string $name
     * @param mixed  $value
     * @return string
     */
    public function render($name, $value = null);
}
