<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType;

class LinkHandlerCollection implements \IteratorAggregate
{
    /**
     * @var LinkHandlerInterface[]
     */
    protected $collection = [];

    /**
     * @var string
     */
    protected $name;

    /**
     * @var int
     */
    protected $language_id;

    /**
     * @param string $name
     * @param int    $language_id
     */
    public function __construct($name = '', $language_id = null)
    {
        $this->name = $name;
        $this->language_id = $language_id;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return int
     */
    public function getLanguageId()
    {
        return $this->language_id;
    }

    public function add(LinkHandlerInterface $handler)
    {
        $this->collection[$handler->getName()] = $handler;
    }

    /**
     * @return LinkHandlerInterface[]
     */
    public function all()
    {
        return $this->collection;
    }

    /**
     * @param string $name
     * @return bool
     */
    public function has($name)
    {
        return isset($this->collection[$name]);
    }

    /**
     * @param string $name
     * @return LinkHandlerInterface|null
     */
    public function get($name)
    {
        if (!$this->has($name)) {
            return null;
        }

        return $this->collection[$name];
    }

    /**
     * {@inheritdoc}
     */
    public function getIterator(): \Traversable
    {
        return new \ArrayIterator($this->all());
    }
}
