<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType;

use Application\Core\Model\Manager\LinkTypeManagerInterface;
use Pongho\Template\Html;

class LinkFacadeFactory
{
    /**
     * @var LinkHandlerCollectionFactory
     */
    protected $collections_factory;

    /**
     * @var LinkTypeManagerInterface
     */
    protected $manager;

    /**
     * @var Html
     */
    protected $html;

    /**
     * @var array
     */
    protected $facades;

    public function __construct(LinkHandlerCollectionFactory $collections_factory, LinkTypeManagerInterface $manager, Html $html)
    {
        $this->collections_factory = $collections_factory;
        $this->manager = $manager;
        $this->html = $html;
    }

    /**
     * @param string $name
     * @param int    $language_id
     * @return LinkFacade
     */
    public function create($name, $language_id)
    {
        return new LinkFacade($this->collections_factory->create($name, $language_id), $this->manager, $this->html);
    }

    /**
     * @param string $name
     * @param int    $language_id
     * @return LinkFacade
     */
    public function get($name, $language_id)
    {
        if (!isset($this->facades[$name][$language_id])) {
            $this->facades[$name][$language_id] = $this->create($name, $language_id);
        }

        return $this->facades[$name][$language_id];
    }
}
