<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType\Handler;

use Application\Core\Entity\LinkTypeDetails;
use Application\Core\Entity\LinkTypeInterface;
use Application\Core\LinkType\LinkHandlerInterface;

/**
 * @fixme: Rinominare in NoValueHandler
 */
class NolinkHandler implements LinkHandlerInterface
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $label;

    /**
     * @var string|null
     */
    protected $group;

    /**
     * @param string $name
     * @param string $label
     * @param string $group
     */
    public function __construct($name, $label, $group = null)
    {
        $this->name = $name;
        $this->label = $label;
        $this->group = $group;
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $value = null)
    {
        return '';
    }

    /**
     * {@inheritdoc}
     */
    public function getUrl(array $request)
    {
        return null;
    }

    /**
     * {@inheritdoc}
     */
    public function getDetails(array $request)
    {
        return new LinkTypeDetails(null, null);
    }

    /**
     * {@inheritdoc}
     */
    public function getValue(LinkTypeInterface $link_type)
    {
        return null;
    }

    /**
     * {@inheritdoc}
     */
    public function getGroup()
    {
        return $this->group;
    }
}
