<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType\Handler;

use Application\Core\Entity\LinkTypeDetails;
use Application\Core\Entity\LinkTypeInterface;
use Application\Core\LinkType\LinkHandlerInterface;
use Application\Core\LinkType\LinkSelectOptionInterface;
use Pongho\Template\Html;

/**
 * @fixme: Rinominare in SelectValueHandler
 */
class ModelHandler implements LinkHandlerInterface
{
    /**
     * @var string
     */
    protected $name;

    /**
     * @var string
     */
    protected $label;

    /**
     * @var Html
     */
    protected $html;

    /**
     * @var string|null
     */
    protected $group;

    /**
     * @var LinkSelectOptionInterface[]
     */
    protected $options = [];

    /**
     * @var array
     */
    protected $select_options = [];

    /**
     * @param string                                                 $name
     * @param string                                                 $label
     * @param \Application\Core\LinkType\LinkSelectOptionInterface[] $select_options
     * @param string                                                 $group
     */
    public function __construct($name, $label, array $select_options, Html $html, $group = null)
    {
        $this->name = $name;
        $this->label = $label;
        $this->html = $html;
        $this->group = $group;

        foreach ($select_options as $option) {
            $this->addOption($option);
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * {@inheritdoc}
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * {@inheritdoc}
     */
    public function render($name, $value = null)
    {
        return '<select name="' . $name . '"><option></option>' . $this->html->select($this->select_options, $value) . '</select>';
    }

    /**
     * {@inheritdoc}
     */
    public function getUrl(array $request)
    {
        if (!isset($request[$this->getName()])) {
            return '';
        }

        $value = $request[$this->getName()];

        if (!isset($this->options[$value])) {
            return '';
        }

        $option = $this->options[$value];

        return $option->getUrl();
    }

    /**
     * {@inheritdoc}
     */
    public function getDetails(array $request)
    {
        if (!array_key_exists($this->getName(), $request)) {
            $request[$this->getName()] = null;
        }

        if (!array_key_exists('language_id', $request)) {
            throw new \InvalidArgumentException('The "LinkTypeDetails" requires a "language_id" value to be set in the request');
        }

        return new LinkTypeDetails($request['language_id'], $request[$this->getName()]);
    }

    /**
     * {@inheritdoc}
     */
    public function getValue(LinkTypeInterface $link_type)
    {
        if ($link_type->getIdentifier() !== $this->getName()) {
            return null;
        }

        return $link_type->getLinkDetails()->getModelId();
    }

    /**
     * {@inheritdoc}
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * @param $option
     */
    protected function addOption(LinkSelectOptionInterface $option)
    {
        $this->select_options[$option->getValue()] = $option->getLabel();
        $this->options[$option->getValue()] = $option;
    }
}
