<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\LinkType;

class Binder
{
    /**
     * @var ResourceInterface[]
     */
    protected $resources = [];

    /**
     * @param string            $name
     */
    public function register($name, ResourceInterface $resource)
    {
        $this->resources[$name] = $resource;
    }

    /**
     * @param string $name
     * @return ResourceInterface
     */
    public function getBound($name)
    {
        if (isset($this->resources[$name])) {
            return $this->resources[$name];
        }

        throw new \LogicException(sprintf('The LinkType resource "%s" is not implemented', $name));
    }
}
