<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Installer\Helper;

class UpdatesLocator
{
    /**
     * @param string $app_name
     * @return array
     */
    public function locate($app_name = null)
    {
        $apps_path = __DIR__ . '/../../../';
        $path = $apps_path . $app_name . '/Updates/*.php';

        $updates = [];
        foreach (glob($path, GLOB_BRACE) as $file_path) {
            $class_name = 'Application\\' . str_replace('/', '\\', substr($file_path, strlen($apps_path), -4));

            $ref = new \ReflectionClass($class_name);

            if ($ref->implementsInterface(\Updates\UpdateInterface::class)) {
                $updates[] = (int) substr($ref->getShortName(), 6);
            }
        }

        return $updates;
    }
}
