<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Installer\Helper;

use Doctrine\DBAL\Connection;
use Doctrine\DBAL\ParameterType;

class AppInstallerHelper
{
    /**
     * @var Connection
     */
    protected $connection;

    public function __construct(Connection $connection)
    {
        $this->connection = $connection;
    }

    /**
     * @param string $app_name
     */
    public function fixRegisteredUpdates($app_name)
    {
        $installed_updates = json_decode($this->getPonghoSetting('installed_updates'));
        $installed_updates = array_unique(array_merge($installed_updates, $this->getAvailableUpdates($app_name)));
        sort($installed_updates);

        $this->updatePonghoSetting('installed_updates', json_encode($installed_updates));

        $max = max($installed_updates);
        $db_version = $this->getPonghoSetting('db_version');

        if ($db_version < $max) {
            $this->updatePonghoSetting('db_version', $max);
        }
    }

    /**
     * @param string $app_name
     * @return array
     */
    protected function getAvailableUpdates($app_name = null)
    {
        return (new UpdatesLocator())->locate($app_name);
    }

    /**
     * @param string $key
     * @return string
     */
    protected function getPonghoSetting($key)
    {
        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        return $this->connection->fetchOne(
            "SELECT value FROM pongho_settings WHERE $key_field_name = :key",
            ['key' => $key]
        );
    }

    /**
     * @param string $key
     * @param string $value
     */
    protected function updatePonghoSetting($key, $value)
    {
        $key_field_name = $this->connection->getDatabasePlatform()->quoteIdentifier('key');

        $this->connection->update(
            'pongho_settings',
            [
                'value' => $value,
            ],
            [
                $key_field_name => $key,
            ],
            [
                'value'         => ParameterType::STRING,
                $key_field_name => ParameterType::STRING,
            ]
        );
    }
}
