<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Translation;

use Pongho\Core\LocalizationInterface;
use Pongho\Utilities\Inflector;

class Translator extends \Symfony\Component\Translation\Translator implements LocalizationInterface
{
    /**
     * {@inheritdoc}
     */
    public function get($key, $count = null)
    {
        if (is_int($count)) {
            match ($count) {
                0       => $key .= '_zero',
                1       => $key .= '_one',
                default => $key .= '_more',
            };

            $message = sprintf(
                $this->trans($key, [], 'lang', $this->getLocale()),
                $count
            );
        } else {
            $message = $this->trans($key, [], 'lang', $this->getLocale());
        }

        // Se la chiave e il messaggio corrispondono, significa che non c'è la traduzione
        if ($message === $key) {
            return Inflector::humanize($key);
        }

        return $message;
    }

    /**
     * Aggiunge le traduzioni dell'applicazione al servizio di traduzione
     *
     * @param string $app_name
     * @param string $culture
     *
     * @deprecated
     */
    public function addApplicationTranslations($app_name, $culture)
    {
        $this->addResource('pongho_app', $app_name, $culture);
    }
}
