<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Locale\it_IT;

use Application\Core\I18n\LocaleInterface;

class Locale implements LocaleInterface
{
    /**
     * {@inheritdoc}
     */
    public function formatPrice($price, $showCurrency = true, $showDecimal = true)
    {
        $price = $showDecimal ? (float) $price : round($price);

        return ($showCurrency ? '€ ' : '') . number_format(floatval($price), $showDecimal ? 2 : 0, ',', '.');
    }

    /**
     * {@inheritdoc}
     */
    public function parsePrice($price)
    {
        $price = trim($price, '€ ');
        $price = str_replace('.', '', $price);
        $price = str_replace(',', '.', $price);

        return (float) $price;
    }
}
