<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Locale;

use Application\Core\I18n\LocaleInterface;

class IntlLocale implements LocaleInterface
{
    /**
     * @var string
     */
    private $localeName;

    /**
     * IntlLocale constructor.
     *
     * @param string $localeName
     */
    public function __construct($localeName)
    {
        $this->localeName = $localeName;
    }

    /**
     * {@inheritdoc}
     */
    public function formatPrice($price, $showCurrency = true, $showDecimal = true)
    {
        if ($showDecimal !== true) {
            trigger_error(__METHOD__ . '(): The showDecimal parameter is not supported.', E_USER_WARNING);
        }

        if ($showCurrency) {
            $formatter = new \NumberFormatter($this->localeName, \NumberFormatter::CURRENCY);
        } else {
            $formatter = new \NumberFormatter($this->localeName, \NumberFormatter::DECIMAL);

            // Forzo i decimali a 2 perché NumberFormatter::DECIMAL_ALWAYS_SHOWN non sembra funzionare...
            $formatter->setAttribute(\NumberFormatter::FRACTION_DIGITS, 2);
        }

        return $formatter->format($price);
    }

    /**
     * {@inheritdoc}
     */
    public function parsePrice($price)
    {
        $result = (new \NumberFormatter($this->localeName, \NumberFormatter::CURRENCY))->parse($price);

        if ($result === false) {
            $result = (new \NumberFormatter($this->localeName, \NumberFormatter::DECIMAL))->parse($price);
        }

        if ($result === false) {
            throw new \RuntimeException(sprintf('Unable to parse price "%s"', $price));
        }

        return $result;
    }
}
