<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Country\IT;

use Application\Core\I18n\Address\AddressInterface;
use Application\Core\I18n\Address\AddressValidatorInterface;

class AddressValidator implements AddressValidatorInterface
{
    /**
     * {@inheritdoc}
     */
    public function validate(AddressInterface $address, array &$errors = [])
    {
        foreach ($this->required() as $name => $options) {
            [$method, $error_message] = $options;

            $value = $address->$method();

            if (empty($value)) {
                $errors[$name] = $error_message;
            }
        }

        if (!isset($errors['postcode']) && !preg_match('#^\d{5}$#', $address->getPostCode())) {
            $errors['postcode'] = 'invalid_postcode_format';
        }

        return $errors === [];
    }

    /**
     * @return array
     */
    protected function required()
    {
        return [
            'name'      => ['getFirstName', 'required_name'],
            'surname'   => ['getLastName', 'required_surname'],
            'address'   => ['getStreet', 'required_address'],
            'city'      => ['getCity', 'required_city'],
            'postcode'  => ['getPostCode', 'required_postcode'],
            'province'  => ['getProvince', 'required_province'],
            'country'   => ['getCountry', 'required_country'],
            'telephone' => ['getTelephone', 'required_telephone'],
        ];
    }
}
