<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Country\IT;

use Application\Core\I18n\Address\AddressInterface;
use Application\Core\I18n\Address\AddressRendererInterface;
use Application\Core\Model\Province;

class AddressRenderer implements AddressRendererInterface
{
    /**
     * {@inheritdoc}
     */
    public function render(AddressInterface $address)
    {
        $rows = [];
        $rows[] = $this->renderName($address);
        $rows[] = $address->getStreet();

        if ($address->getAdditionalInfo()) {
            $rows[] = $address->getAdditionalInfo();
        }

        $rows[] = $this->renderCityAndPostCodeAndProvince($address);

        if ($address->getCountry()) {
            $rows[] = $address->getCountry();
        }

        if ($address->getTelephone()) {
            $rows[] = 'T. ' . $address->getTelephone();
        }

        return implode('<br>', $rows);
    }

    /**
     * @return string
     */
    protected function renderName(AddressInterface $address)
    {
        return trim($address->getFirstName() . ' ' . $address->getLastName());
    }

    /**
     * @return string
     */
    protected function renderCityAndPostCodeAndProvince(AddressInterface $address)
    {
        $city = implode(' - ', [$address->getPostCode(), $address->getCity()]);
        $province = $address->getProvince();

        if ($province instanceof Province) {
            return $city . ' (' . $province->plate . ')';
        }

        if (is_string($province)) {
            return $city . ' (' . $province . ')';
        }

        return $city;
    }
}
