<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Address;

/**
 * AddressInterface.
 */
interface AddressInterface
{
    /**
     * @return string
     */
    public function getFirstName();

    /**
     * @return string
     */
    public function getLastName();

    /**
     * @return string
     */
    public function getCompany();

    /**
     * @return string
     */
    public function getStreet();

    /**
     * @return string
     */
    public function getAdditionalInfo();

    /**
     * @return string
     */
    public function getCity();

    /**
     * @return string
     */
    public function getPostCode();

    /**
     * @return \Application\Core\Model\Province
     */
    public function getProvince();

    /**
     * @return \Application\Core\Model\Country
     */
    public function getCountry();

    /**
     * @return string
     */
    public function getTelephone();
}
