<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\I18n\Address;

use Application\Core\Model\Country;
use Application\Core\Model\Province;

/**
 * Address.
 *
 * Implementazione base della AddressInterface.
 */
class Address implements AddressInterface
{
    protected $first_name;

    protected $last_name;

    protected $company;

    protected $street;

    protected $additional_info;

    protected $postcode;

    protected $city;

    protected $province;

    protected $country;

    protected $telephone;

    /**
     * @param string   $first_name
     * @param string   $last_name
     * @param string   $company
     * @param string   $street
     * @param string   $additional_info
     * @param string   $postcode
     * @param string   $city
     * @param Province $province
     * @param Country  $country
     * @param string   $telephone
     */
    public function __construct($first_name = '', $last_name = '', $company = '', $street = '', $additional_info = '', $postcode = '', $city = '', ?Province $province = null, ?Country $country = null, $telephone = '')
    {
        $this->first_name = $first_name;
        $this->last_name = $last_name;
        $this->company = $company;
        $this->street = $street;
        $this->additional_info = $additional_info;
        $this->postcode = $postcode;
        $this->city = $city;
        $this->province = $province;
        $this->country = $country;
        $this->telephone = $telephone;
    }

    /**
     * {@inheritdoc}
     */
    public function getFirstName()
    {
        return $this->first_name;
    }

    /**
     * {@inheritdoc}
     */
    public function getLastName()
    {
        return $this->last_name;
    }

    /**
     * {@inheritdoc}
     */
    public function getCompany()
    {
        return $this->company;
    }

    /**
     * {@inheritdoc}
     */
    public function getStreet()
    {
        return $this->street;
    }

    /**
     * {@inheritdoc}
     */
    public function getAdditionalInfo()
    {
        return $this->additional_info;
    }

    /**
     * {@inheritdoc}
     */
    public function getCity()
    {
        return $this->city;
    }

    /**
     * {@inheritdoc}
     */
    public function getPostcode()
    {
        return $this->postcode;
    }

    /**
     * {@inheritdoc}
     */
    public function getProvince()
    {
        return $this->province;
    }

    /**
     * {@inheritdoc}
     */
    public function getCountry()
    {
        return $this->country;
    }

    /**
     * {@inheritdoc}
     */
    public function getTelephone()
    {
        return $this->telephone;
    }
}
