<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

declare(strict_types=1);

namespace Application\Core\Form\Field;

use Pongho\Form\Exception\FieldException;
use Pongho\Form\Field\HiddenField;
use ReCaptcha\ReCaptcha;

final class Recaptcha3Field extends HiddenField
{
    /**
     * @throws FieldException
     */
    public function handle(array $data)
    {
        $recaptcha = new ReCaptcha($this->getSetting('recaptcha3_secret_key'));
        $request = $this->getForm()->getRequest();

        $recaptcha
            ->setExpectedHostname($request->getHost())
            ->setExpectedAction('submit')
            ->setScoreThreshold(0.5)
        ;

        $token = (string) ($data[$this->getKey()] ?? '');

        $result = $recaptcha->verify(
            $token,
            $request->getClientIp()
        );

        if (!$result->isSuccess()) {
            $errors = array_map(function ($item) {
                $item = addslashes($item);
                return "\"$item\"";
            }, $result->getErrorCodes());

            throw new FieldException(implode(', ', $errors));
        }
    }
}
