<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Form\Field;

use Application\Core\Model\Province;
use Pongho\Form\Field\SelectField;

class ProvinceField extends SelectField
{
    /**
     * @var string
     */
    protected $value_type;

    /**
     * Imposta il tipo di valore da utilizzare per la select delle province.
     *
     * @param string $value_type
     * @throws \InvalidArgumentException
     * @return $this
     */
    public function setValueType($value_type)
    {
        if (!in_array($value_type, ['id', 'name', 'plate'])) {
            throw new \InvalidArgumentException(sprintf('Value type "%s" is not valid', $value_type));
        }

        $this->value_type = $value_type;

        return $this;
    }

    /**
     * Restituisce il tipo di valore da utilizzare per la select delle province.
     *
     * @return string
     */
    public function getValueType()
    {
        if (!$this->value_type && $this->hasSetting('value_type')) {
            $this->value_type = $this->getSetting('value_type');
        }

        if ($this->value_type) {
            return $this->value_type;
        }

        return 'id';
    }

    /**
     * @throws \BadMethodCallException
     */
    public function setOptions($options): never
    {
        throw new \BadMethodCallException('You could’t override the provinces!');
    }

    /**
     * {@inheritdoc}
     */
    public function getOptions()
    {
        if (empty($this->options)) {
            $field = $this->getValueType();

            /** @var Province $province */
            foreach (Province::all(['order' => 'name']) as $province) {
                $this->options[$province->{$field}] = $province->getName();
            }
        }

        return $this->options;
    }
}
