<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author  Daniele De Nobili
 * @package Application\Core
 */

namespace Application\Core\Form\Field;

use Application\Core\Localization;
use Pongho\Form\Field\ChecklistField;

/**
 * PermitsChecklistField.
 */
class PermitsChecklistViewClosure
{
    /**
     * @var \Application\Core\Model\Permit[]
     */
    protected $permits = [];

    /**
     * @var \Application\Core\Localization
     */
    protected $lang;

    /**
     * @var int
     */
    protected $row_counter;

    /**
     * @param \Application\Core\Model\Permit[] $permits
     */
    public function __construct(Localization $lang, array $permits)
    {
        $this->lang = $lang;
        $this->permits = $permits;
    }

    /**
     * @return string
     */
    public function __invoke(ChecklistField $field)
    {
        $this->row_counter = 1;

        $keys = [];
        foreach ($this->permits as $permit) {
            $keys[] = $permit->key;
            $this->permits[$permit->key] = $permit;
        }

        $compiler = new PermitsCheckListNamespaceCompiler($keys);

        return $this->recursiveRender($field, $compiler->compile());
    }

    /**
     * @return string
     */
    protected function recursiveRender(ChecklistField $field, array $namespaces)
    {
        $code = '';

        foreach ($namespaces as $label => $namespace) {
            $code .= '<fieldset class="permits-checklist"><h4>' . $this->lang->get('permit_ns_' . $label) . '</h4>';

            $input = [];
            foreach ($namespace['permits'] as $permit_key) {
                $permit = $this->permits[$permit_key];

                $attributes = [
                    'type'  => 'checkbox',
                    'value' => $permit->id,
                    'name'  => $field->getName(),
                ];

                if (in_array($permit->id, $field->getValue())) {
                    $attributes['checked'] = 'checked';
                }

                $input[] = sprintf(
                    '<label class="field-option option-' . $this->row_counter++ . '"><input%s> <span>%s</span></label>',
                    $this->renderAttributes($attributes),
                    $this->lang->get('permit_' . $permit_key)
                );
            }

            $code .= implode(PHP_EOL, $input);

            if (isset($namespace['fieldset'])) {
                $code .= $this->recursiveRender($field, $namespace['fieldset']);
            }

            $code .= '</fieldset>';
        }

        return $code;
    }

    protected function renderAttributes(array $attributes)
    {
        $code = '';

        foreach ($attributes as $attribute => $value) {
            $code .= sprintf(' %s="%s"', $attribute, $value);
        }

        return $code;
    }
}
