<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele De Nobili
 * @package Application\Core
 */

namespace Application\Core\Form\Field;

class PermitsCheckListNamespaceCompiler
{
    protected $keys;

    protected $namespaces = [];

    public function __construct(array $keys)
    {
        $this->keys = $keys;
    }

    public function compile()
    {
        foreach ($this->keys as $key) {
            $this->addKey($key);
        }

        return $this->namespaces;
    }

    private function addKey($key)
    {
        $this->namespaces = $this->compileToken($this->namespaces, $key);
    }

    private function compileToken(array $namespaces, $key, $i = 1)
    {
        $tokens = explode('.', (string) $key);
        $base = count($tokens) > $i ? implode('.', array_slice($tokens, 0, $i)) : implode('.', $tokens);

        if (!isset($namespaces[$base])) {
            $namespaces[$base] = [
                'permits' => [],
            ];
        }

        $i++;

        if (count($tokens) > $i) {
            if (!isset($namespaces[$base]['fieldset'])) {
                $namespaces[$base]['fieldset'] = [];
            }

            foreach ($namespaces[$base]['permits'] as $index => $permit) {
                $permit_tokens = explode('.', (string) $permit);
                $key_tokens = explode('.', (string) $key);

                array_pop($key_tokens);

                if ($permit_tokens === $key_tokens) {
                    unset($namespaces[$base]['permits'][$index]);
                    $namespaces[$base]['fieldset'][$permit]['permits'][] = $permit;
                }
            }

            $namespaces[$base]['fieldset'] = $this->compileToken($namespaces[$base]['fieldset'], $key, $i);
        } else {
            $namespaces[$base]['permits'][] = $key;
        }

        return $namespaces;
    }
}
