<?php

/**
 * Questo file è parte di Pongho 2.0.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Form\Field;

use Pongho\Form\BaseField;

class GeoField extends BaseField
{
    private static $VALID_POSITIONS = ['lat', 'lng'];

    /**
     * {@inheritdoc}
     */
    public function emptyValue()
    {
        return [
            [
                'lat' => '45.638147',
                'lng' => '12.595686',
            ],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function getValue()
    {
        $value = parent::getValue();

        if (!is_array($value)) {
            $value = $this->emptyValue();
        }

        return $this->validateValue($value);
    }

    /**
     * @return array|mixed
     */
    private function validateValue(array $value)
    {
        $positions = [];
        foreach ($value as $position) {
            if (is_array($position) && array_keys($position) === self::$VALID_POSITIONS) {
                $positions[] = $position;
            }
        }

        if ($positions === []) {
            return $this->emptyValue();
        }

        return $positions;
    }

    /**
     * {@inheritdoc}
     */
    public function setValue($value)
    {
        if (!is_array($value)) {
            $value = $this->emptyValue();
        }

        return parent::setValue($value);
    }

    /**
     * {@inheritdoc}
     */
    public function getTag()
    {
        $data = [
            'field-name' => $this->getName(),
        ];

        if ($this->getSetting('multiple', false)) {
            $data['multiple'] = true;
        }

        if ($this->hasSetting('zoom')) {
            $data['geo-zoom'] = $this->getSetting('zoom');
        }

        if ($this->isReadonly()) {
            $data['readonly'] = true;
        }

        $attributes = '';
        foreach ($data as $name => $value) {
            $attributes .= sprintf(' data-%s="%s"', $name, $value);
        }

        $code = '<div id="' . $this->getId() . '" class="geo-localization"' . $attributes . '>';

        $counter = 0;
        $fieldName = $this->getName();
        foreach ($this->getValue() as $position) {
            $code .= '<address data-lat="' . $position['lat'] . '" data-lng="' . $position['lng'] . '"></address>';
            $code .= '<input type="hidden" name="' . $fieldName . '[' . $counter . '][lat]" value="' . $position['lat'] . '">';
            $code .= '<input type="hidden" name="' . $fieldName . '[' . $counter . '][lng]" value="' . $position['lng'] . '">';

            $counter++;
        }

        return $code . '</div>';
    }
}
