<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Admin
 */

namespace Application\Core\Form\Field;

use Pongho\Form\Field\TextField;

/**
 * PriceField.
 *
 * Questo campo richiede 2 colonne in database relativamente 'fieldname' e 'fieldname_type' la seconda è necessaria
 * a gestire il formato dello sconto, ossia se è uno sconto in percentuale o uno sconto in valuta
 */
class DiscountField extends TextField
{
    /**
     * {@inheritdoc}
     */
    public function getValue()
    {
        return format_price(parent::getValue(), false) . $this->getDiscountType();
    }

    /**
     * {@inheritdoc}
     */
    public function setValue($value)
    {
        if (($pos = strpos((string) $value, '%')) !== false) {
            // Sconto percentuale
            $this->setDiscountType('%');

            return parent::setValue(parse_price(substr((string) $value, 0, $pos)));
        } else {
            // Sconto fisso
            $this->setDiscountType('');

            return parent::setValue(parse_price($value));
        }
    }

    /**
     * @return string
     */
    protected function getDiscountType()
    {
        /** @var \Pongho\Form\Fieldset $parent */
        $parent = $this->getParent();

        return $parent->getSubject()->get($this->getKey() . '_type');
    }

    /**
     * @param string $type
     */
    protected function setDiscountType($type)
    {
        /** @var \Pongho\Form\Fieldset $parent */
        $parent = $this->getParent();

        $parent->getSubject()->set($this->getKey() . '_type', $type);
    }
}
