<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

use Pongho\Utilities\DateTime;

/**
 * Interface UserDetailsInterface
 */
interface UserDetailsInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * @return null|int
     */
    public function getUserId();

    /**
     * @return null|AccountInterface
     */
    public function getAccount();

    /**
     * Restituisce il nome completo dell’utente.
     * Se il nome risulta vuoto verrà utilizzato lo username.
     * È possibile modificare il comportamento di questa funzione tramite l'evento model.pongho_users.name_function.
     *
     * Esempio:
     * <code>
     *   $account->name = 'Paolino';
     *   $account->surname = 'Paperino';
     *   echo $account->name(); // Paolino Paperino
     *   echo $account->name(true); // Paperino Paolino
     * </code>
     *
     * @param boolean $invert Se invertire l’ordine di nome e cognome.
     * @return string
     */
    public function name($invert = false);

    /**
     * @return string
     */
    public function getName();

    /**
     * @param string $name
     * @return mixed
     */
    public function setName($name);

    /**
     * @return string
     */
    public function getSurname();

    /**
     * @param string $surname
     * @return mixed
     */
    public function setSurname($surname);

    /**
     * @return string
     */
    public function getEmail();

    /**
     * @param string $email
     * @return mixed
     */
    public function setEmail($email);

    /**
     * Restituisce il modello dell’avatar.
     *
     * @return ImageInterface
     */
    public function getAvatar();

    /**
     * @return int
     */
    public function getAvatarId();

    /**
     * @param int|\Application\Core\Model\File $avatar
     * @return $this
     */
    public function setAvatar($avatar);

    /**
     * Elimina l’avatar utente.
     *
     * @return boolean
     */
    public function deleteAvatar();

    /**
     * @return string
     */
    public function getDescription();

    /**
     * @param string $description
     * @return mixed
     */
    public function setDescription($description);

    /**
     * @return string
     */
    public function getCompany();

    /**
     * @param string $company
     * @return mixed
     */
    public function setCompany($company);

    /**
     * @return string
     */
    public function getTaxCode();

    /**
     * @param string $tax_code
     * @return mixed
     */
    public function setTaxCode($tax_code);

    /**
     * @return string
     */
    public function getVatNumber();

    /**
     * @param string $vat_number
     * @return mixed
     */
    public function setVatNumber($vat_number);

    /**
     * @return string
     */
    public function getAddress();

    /**
     * @param string $address
     * @return mixed
     */
    public function setAddress($address);

    /**
     * @return string
     */
    public function getAddress2();

    /**
     * @param string $address2
     * @return mixed
     */
    public function setAddress2($address2);

    /**
     * @return string
     */
    public function getCity();

    /**
     * @param string $city
     * @return mixed
     */
    public function setCity($city);

    /**
     * @return string
     */
    public function getPostCode();

    /**
     * @param string $postcode
     * @return mixed
     */
    public function setPostcode($postcode);

    /**
     * @return ProvinceInterface
     */
    public function getProvince();

    /**
     * @param int|ProvinceInterface $province
     * @return mixed
     */
    public function setProvince($province);

    /**
     * @return int
     */
    public function getProvinceId();

    /**
     * @param int $province_id
     * @return mixed
     */
    public function setProvinceId($province_id);

    /**
     * @return CountryInterface
     */
    public function getCountry();

    /**
     * @param int|CountryInterface $country
     * @return mixed
     */
    public function setCountry($country);

    /**
     * @return int
     */
    public function getCountryId();

    /**
     * @param int $country_id
     * @return mixed
     */
    public function setCountryId($country_id);

    /**
     * @return string
     */
    public function getTelephone();

    /**
     * @param string $telephone
     * @return mixed
     */
    public function setTelephone($telephone);

    /**
     * @return string
     */
    public function getMobile();

    /**
     * @param string $mobile
     * @return mixed
     */
    public function setMobile($mobile);

    /**
     * @return string
     */
    public function getFax();

    /**
     * @param string $fax
     * @return mixed
     */
    public function setFax($fax);

    /**
     * @return string
     */
    public function getWebsite();

    /**
     * @param string $website
     * @return mixed
     */
    public function setWebsite($website);

    /**
     * @return DateTime
     */
    public function getCreationDate();

    /**
     * @return DateTime
     */
    public function getLastUpdateDate();

    /**
     * Restituisce i genitori diretti dell’utente.
     *
     * @return \Application\Core\Model\Account[]
     *
     * @api
     */
    public function getParents();

    /**
     * Imposta i genitori diretti dell’utente.
     *
     * @param AccountInterface[] $parents
     * @return $this
     *
     * @api
     */
    public function setParents(array $parents);

    /**
     * Imposta un genitore diretto dell’utente.
     *
     * @param int|AccountInterface $parent_id_or_parent_instance
     * @throws \LogicException
     * @return $this
     *
     * @api
     */
    public function setParent($parent_id_or_parent_instance);

    /**
     * Rimuove un genitore diretto dell’utente.
     *
     * @param int|AccountInterface $parent_id_or_instance
     * @return bool
     *
     * @api
     */
    public function delParent($parent_id_or_instance);

    /**
     * Indica se l’utente ha un genitore diretto.
     *
     * @param int $parent_id L'ID del genitore che si vuole controllare.
     * @return bool
     *
     * @api
     */
    public function hasParent($parent_id);

    /**
     * Indica se l'utente ha un certo antenato
     *
     * @param $ancestor_id
     * @return bool
     */
    public function hasAncestor($ancestor_id);

    /**
     * Restituisce i discendenti.
     *
     * @return AccountInterface[]
     */
    public function getDescendants();

    /**
     * Restituisce il numero di discendenti.
     *
     * @return int
     */
    public function countDescendants();

    /**
     * Indica se l'utente ha un certo discendente
     *
     * @param $descendant_id
     * @return bool
     */
    public function hasDescendant($descendant_id);
}
