<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface SettingsInterface
 */
interface SettingsInterface
{
    /**
     * Indica se l’opzione esiste.
     *
     * @param $name
     * @return bool
     */
    public function hasOption($name);

    /**
     * Restituisce una opzione.
     *
     * @param string    $name
     */
    public function getOption($name, $default = null);

    /**
     * Imposta una opzione.
     *
     * @param string $name
     * @param mixed  $value
     */
    public function setOption($name, $value);

    /**
     * Elimina una opzione.
     *
     * @param string $name
     */
    public function delOption($name);

    /**
     * Restituisce tutte le opzioni.
     *
     * @return array
     */
    public function allOptions();
}
