<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface RoleInterface
 */
interface RoleInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * @return string
     */
    public function getName();

    /**
     * @return string
     */
    public function getDescription();

    /**
     * Restituisce l’elenco dei permessi.
     *
     * @return PermitInterface[]
     */
    public function getPermits();

    /**
     * Restituisce l’elenco delle chiavi dei permessi associati al ruolo.
     *
     * @return array
     */
    public function getPermitsKeys();

    /**
     * Restituisce l’elenco degli ID dei permessi associati al ruolo.
     *
     * @return array
     */
    public function getPermitsIds();

    /**
     * Indica se un permesso è associato al ruolo.
     *
     * @param string $key
     * @return bool
     */
    public function hasPermit($key);

    /**
     * Imposta i permessi per il ruolo.
     *
     * La lista dei permessi passati può essere una lista di permessi intesi
     * come modello, o anche una lista di ID dei permessi.
     *
     * @param int[]|PermitInterface[] $permits
     * @return $this
     */
    public function setPermits(array $permits);

    /**
     * @param string|PermitInterface $permitOrPermitKey
     * @return $this
     */
    public function addPermit($permitOrPermitKey);

    /**
     * @param string|PermitInterface $permitOrPermitKey
     * @return $this
     */
    public function removePermit($permitOrPermitKey);

    /**
     * Elimina le associazioni con i permessi.
     *
     * @return $this
     */
    public function delPermits();
}
