<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Entity;

/**
 * Interface NotificationTemplateInterface
 */
interface NotificationTemplateInterface
{
    /**
     * @return int
     */
    public function getId();

    /**
     * @return string
     */
    public function getNotificationName();

    /**
     * @return string
     */
    public function getSenderToAdmin();

    /**
     * @return string
     */
    public function getRecipientToAdmin();

    /**
     * @return string
     */
    public function getReplyToAdmin();

    /**
     * @return string
     */
    public function getCcToAdmin();

    /**
     * @return string
     */
    public function getBccToAdmin();

    /**
     * @return string
     */
    public function getSubjectToAdmin();

    /**
     * @return string
     */
    public function getContentToAdmin();

    /**
     * @return string
     */
    public function getSenderToUser();

    /**
     * @return string
     */
    public function getRecipientToUser();

    /**
     * @return string
     */
    public function getReplyToUser();

    /**
     * @return string
     */
    public function getCcToUser();

    /**
     * @return string
     */
    public function getBccToUser();

    /**
     * @param int $language_id
     * @return string
     */
    public function getSubjectToUser($language_id);

    /**
     * @param int $language_id
     * @return string
     */
    public function getContentToUser($language_id);
}
